<?php

/**
 * Class WPML_Jet_Elements_Scroll_Navigation
 */
class WPML_Jet_Elements_Scroll_Navigation extends WPML_Elementor_Module_With_Items {

	/**
	 * @return string
	 */
	public function get_items_field() {
		return 'item_list';
	}

	/**
	 * @return array
	 */
	public function get_fields() {
		return array( 'item_label' );
	}

	/**
	 * @param string $field
	 *
	 * @return string
	 */
	protected function get_title( $field ) {
		switch( $field ) {
			case 'item_label':
				return esc_html__( 'Jet Scroll Navigation: Label', 'jet-elements' );

			default:
				return '';
		}
	}

	/**
	 * @param string $field
	 *
	 * @return string
	 */
	protected function get_editor_type( $field ) {
		switch( $field ) {
			case 'item_label':
				return 'LINE';

			default:
				return '';
		}
	}

}
